/*
 * OpcionsClient.java
 *
 * Created on 8 de junio de 2008, 16:21
 */

package entitats;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.swing.CellEditor;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

/**
 *
 * @author Administrador
 * @version
 */

public class OpcionsClient extends org.apache.struts.action.ActionForm {
    
    private boolean nif;
    private boolean telefon;
    private boolean adresa;
    private ArrayList <Client> llistatClients = new ArrayList();
    private String llista; //Contindra la taula que es retornara en format html per mostrar el contingut del arraylist llistatclients
    private boolean propietari;
    private boolean llogater;
    private String llistar; //Conte informacio de si el que es vol llistar es un llogater o propietari
    private boolean empresa;
    private boolean particular;
    private String error;
    private String tipusClient;
    
    
    public boolean isNif() {
        return nif;
    }
    
    public void setNif(boolean nif) {
        this.nif = nif;
    }
    
    public boolean isTelefon() {
        return telefon;
    }
    
    public void setTelefon(boolean telefon) {
        this.telefon = telefon;
    }
    
    public boolean isAdresa() {
        return adresa;
    }
    
    public void setAdresa(boolean adresa) {
        this.adresa = adresa;
    }
    
    public ArrayList getLlistatClients() {
        return llistatClients;
    }
    
    public void setLlistatClients(ArrayList llistatClients) {
        this.llistatClients = llistatClients;
    }
    
    public void buidaLlistatClients() {
        this.llistatClients.clear();
    }
    
    public String getLlistaClients() {
        if (llistatClients.size()>0) {
            llista = "";
            for (Client client : llistatClients) {
                llista += " <table>"+
                        "<tr>"+
                        "<td colspan='2'><font size=5><b>"+client.getNom()+" "+client.getCognoms()+"</b></font> " +
                        "<a href=carregaPropietaris?action=edicio&id="+client.getIdClient()+">[editar]</a> " +
                        "<a href=carregaPropietaris?action=baixa&id="+client.getIdClient()+">[baixa]</a></td>"+
                        "</tr>";
                
                if (!this.isNif()){
                    llista += "<tr>" +
                            "<td>NIF:</td>" +
                            "<td>"+client.getNif()+"</td>" +
                            "</tr>"; }
                
                if (!this.isAdresa()){
                    llista += "<tr>" +
                            "<td>Adre&ccedil;a:</td>" +
                            "<td>"+client.getAdresa()+"</td>" +
                            "</tr>"; }
                
                if (!this.isTelefon()){
                    llista +=  "<tr>" +
                            "<td>Telefon:</td>" +
                            "<td>"+client.getTelefon()+"</td>" +
                            "</tr>"; }
                
                llista +=  " <tr>" +
                        "<td>Locals en propietat: </td>" +
                        "<td>"+client.getLocalsEnPosesio()+"</td>" +
                        "</tr>" +
                        
                        "<tr>" +
                        "<td>Locals llogats </td>" +
                        "<td>"+client.getLocalsLlogats()+"</td>" +
                        "</tr>";
                
                if (this.isLlogater()) {
                    llista +=  "<b>Preferencies del llogater</b>" +
                            "<table class='menu'> " +
                            "<tr>" +
                            "<td>Superficie minima</td>" +
                            "<td>"+client.getSuperficieMinima()+"</td>" +
                            "</tr>" +
                            
                            " <tr>" +
                            "<td>Tipus de local</td>" +
                            "<td>"+client.getTipusLocal()+"</td>" +
                            "</tr>" +
                            
                            " <tr>" +
                            "<td>Zona</td>" +
                            "<td>"+client.getIdZona()+"</td>" +
                            "</tr>" +
                            "</table>";
                }
                
                llista += "</table>" +
                        "<br>";
            }//llistar preferencies del llogaters
        }
        return llista;
    }
    
    public String getLlista() {
        return llista;
    }
    
    public void setLlista(String llista) {
        this.llista = llista;
    }
    
    public boolean isPropietari() {
        return propietari;
    }
    
    public void setPropietari(boolean propietari) {
        this.propietari = propietari;
    }
    
    public boolean isLlogater() {
        return llogater;
    }
    
    public void setLlogater(boolean llogater) {
        this.llogater = llogater;
    }
    
    public boolean isEmpresa() {
        return empresa;
    }
    
    public void setEmpresa(boolean empresa) {
        this.empresa = empresa;
    }
    
    public boolean isParticular() {
        return particular;
    }
    
    public void setParticular(boolean particular) {
        this.particular = particular;
    }
    
    public String getError() {
        return error;
    }
    
    public void setError(String error) {
        this.error = error;
    }
    
    public String getTipusClient() {
        return tipusClient;
    }
    
    public void setTipusClient(String tipusClient) {
        this.tipusClient = tipusClient;
    }

    public String getLlistar() {
        return llistar;
    }

    public void setLlistar(String llistar) {
        this.llistar = llistar;
    }
}
